;====================================================
;
;	Api92/Api89 Example Source Code
;
;	(c) NeXO Software, Ibrahim - Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;	web : http://perso.wanadoo.fr/scherrer/ben/
;
;	File>	filecmp.xas
;	> This example is a real program that shows
;	how powerful is the Api92/Api89 library.
;====================================================


;--------------------- Includes ---------------------

	include "tios.h"
	include	"api92.h"
	include "api92cst.h"

;#ifdef TIPLUS
;#ifdef TI89
	xdef	_ti89
;#else
	xdef	_ti92plus
;#endif
;#endif

;------------ Start of assembly program -------------

	xdef	_main
	xdef	_comment

;#ifdef TI89
OX	equ	-40
OY	equ	-10
;#else
OX	equ	0
OY	equ	0
;#endif

;----------------------------------------------------
; Program Entry Point
;----------------------------------------------------
_main
	clr.l	d7
	clr.l	d5
	clr.l	d6
	move.b	#50,ieInterface+1	;use animation

RdLoop:	tst.w	d7			;delete buffer
	beq.s	\nodelete		;if it 
	move.w	d7,-(a7)		;exists
	jsr	tios::HeapFree
	addq.l	#2,a7
	clr.l	d7

\nodelete lea	ieInterface(PC),a0
	jsr	api92::InterfaceEngine
	move.b	#0,ieInterface+1	;remove animation

	suba.w	#40,a7			;create stack frame
	move.l	a7,a2

	tst.w	d5
	beq.s	\novar1
	move.w	d5,d1
	bsr	VarName
	tst.w	d0
	beq.s	\novar1
	moveq.w	#45+OX,d0
	moveq.w	#47+OY,d1
	jsr	api92::draw_StringSpecial

\novar1	tst.w	d6
	beq.s	\novar2
	move.w	d6,d1
	bsr	VarName
	tst.w	d0
	beq.s	\novar2
	moveq.w	#45+OX,d0
	moveq.w	#74+OY,d1
	jsr	api92::draw_StringSpecial

\novar2	adda.w	#40,a7


Loop	jsr	api92::WaitKey
	cmp.w	#268,d0			;[F1]
	beq.s	var1
	cmp.w	#269,d0			;[F2]
	beq.s	var2
	cmp.w	#13,d0
	beq.s	enter
	cmp.w	#264,d0
	bne.s	Loop

	rts

;----------------------------------------------------
;	a2.l : addr of buffer
;	d1.w : hdl of file
;Out>	d0.w : 0 if error
;	a1.l : addr of string if successful
;----------------------------------------------------
VarName:
	jsr	api92::vat_FindHdlEverywhere
	tst.w	d2
	beq.s	\error
	subq.w	#1,d2			;index
	moveq.w	#30,d1
	move.l	a2,a0
	jsr	api92::nf_GetVatName
	tst.w	d1
	bne.s	\error
	move.l	a0,a1
	moveq.w	#1,d1			;success
\exit	rts
\error	clr.w	d0
	bra.s	\exit

;----------------------------------------------------
; Selection of Var1
;----------------------------------------------------
var1:	lea	SelectFileHeader(PC),a0
	jsr	api92::SelectFileComponent
	tst.w	d0
	beq	RdLoop
	move.w	d1,d5			;save var1 hdl
	bra	RdLoop

;----------------------------------------------------
; Selection of Var2
;----------------------------------------------------
var2:	lea	SelectFileHeader(PC),a0
	jsr	api92::SelectFileComponent
	tst.w	d0
	beq	RdLoop
	move.w	d1,d6			;save var2 hdl
	bra	RdLoop

;----------------------------------------------------
; When Enter is pressed
;----------------------------------------------------
enter:	tst.w	d5
	beq.s	\error1
	tst.w	d6
	bne.s	\skip
\error1	lea	ieError1(PC),a0
	bra	\error

\skip	moveq.w	#4,d1			;create a buffer
	jsr	api92::array_Create
	tst.w	d0
	beq	\error2
	move.w	d0,d7			;Save hdl of buffer

	move.w	d5,d0
	jsr	api92::DEREFd0a0
	move.l	a0,a5			;addr of var1
	move.w	d6,d0
	jsr	api92::DEREFd0a0
	move.l	a0,a6			;addr of var2

	move.l	a5,a3			;save to calculate
	move.l	a6,a4			;offset after
	move.w	(a6),d4			;save size2
	move.w	(a5),d3			;save size1
	cmp.w	d3,d4
	bne	\error3
	subq.l	#1,d4			;for dbra

;----------------------------------------------------
; Compare files and create the buffer
;----------------------------------------------------
\compare
	move.l	a3,d3
	sub.l	a5,d3			;calc offset

	cmp.b	(a3)+,(a4)+		;compare
	beq.s	\ok


	move.w	d7,d0			;Buffer hdl
	moveq.w	#4,d1			;size of items
	move.l	d3,-(a7)		;push offset
	move.l	a7,a0			;item to add
	jsr	api92::array_AddItem
	addq.l	#4,a7			;delete stack frame
	tst.w	d1
	bne.s	\error2
	
	move.w	d5,d0			;we MUST get the new addr
	jsr	api92::DEREFd0a0	;because it may have change
	move.l	a0,a5			;if the addr of the files 
	lea	1(a5,d3.w),a3		;have change during the
	move.w	d6,d0			;resizing of the array
	jsr	api92::DEREFd0a0
	move.l	a0,a6
	lea	1(a6,d3.w),a4
\ok	dbra.s	d4,\compare


;----------------------------------------------------
; Show differences
;----------------------------------------------------

	lea	ieResult(PC),a0
	jsr	api92::InterfaceEngine

	move.w	d7,d0
	jsr	api92::DEREFd0a0
	lea	2(a0),a1		;
	move.w	(a1)+,d0		;get nb items
	beq.s	\nodiff

	move.w	d5,hVar1		;for DrawItem
	move.w	d6,hVar2

	move.w	d0,ResultListViewHeader	;nb items
	lea	ResultListViewHeader(PC),a0
	jsr	api92::ListViewComponent

	bra	RdLoop

\nodiff	lea	ieNoDiff(PC),a0
	bra	\error

\error2	lea	ieError2(PC),a0
	bra	\error

\error3	lea	ieError3(PC),a0

\error:
	jsr	api92::InterfaceEngine
	jsr	api92::WaitKey
	bra	RdLoop


;----------------------------------------------------
; CallBack function
;----------------------------------------------------
api92CB_DrawItem:
	addq.l	#1,d1			;add 1 to y
	add.w	#13,d0

	suba.w	#40,a7			;create stack frame
	move.l	a7,a2			;its address

	movem.l	d0-d1,-(a7)
	clr.w	d0			;font0
	jsr	api92::SetFont

	move.w	hVar2(PC),d0
	jsr	api92::DEREFd0a0
	adda.l	(a1),a0			;add offset
	clr.w	d0
	move.b	(a0),d0
	move.w	d0,-(a7)		;push var2

	move.w	hVar1(PC),d0
	jsr	api92::DEREFd0a0
	adda.l	(a1),a0			;add offset
	clr.w	d0
	move.b	(a0),d0
	move.w	d0,-(a7)		;push var1

	move.l	(a1),d0			;get offset
	move.l	d0,-(a7)		;create formatted
	pea	sFormat(PC)		;string using 
	move.l	a2,-(a7)		;sprintf
	jsr	tios::sprintf
	lea	16(a7),a7
	movem.l	(a7)+,d0-d1

	move.l	a2,a1			;draw string
	jsr	api92::draw_StringSpecial

	adda.w	#40,a7			;delete stack frame

	moveq.w	#1,d1			;font1
	jsr	api92::SetFont
	rts



;------------------- Program Data -------------------

SelectFileHeader:
	dc.w	70+OX,42+OY	;X,Y
	dc.w	5		;Nb Item per page
	dc.w	100		;Width of the component
	dc.w	0		;Current Folder
	dc.b	%00011000,0	;Flags
	dc.l	0		;api92CB_Filter
	dc.l	0		;api92CB_lvKeyDown
	dc.l	0		;api92CB_lvKey
	dc.l	0		;api92CB_lvOnSelect
	dc.l	0		;api92CB_lvDrawItem


ResultListViewHeader:
	dc.w	0		;Nb of items
	dc.w	6		;Nb item per page
	dc.w	50+OX,35+OY	;X,Y
	dc.l	0		;reserved
	dc.w	135		;width
	dc.w	4		;constant size
	dc.w	0		;constant height
	dc.b	%00000001,0	;flag
	dc.l	0		;api92CB_lvKeyDown
	dc.l	0		;api92CB_lvKey
	dc.l	0		;api92CB_lvOnSelect
	dc.l	api92CB_DrawItem ;api92CB_lvDrawItem
	dc.l	0		;api92CB_lvItemsProperties

ieInterface:
	dc.b	IE_ANIMEDWIN2,50,40+OX,20+OY,199+OX,100+OY,"File Compare v1.00",0
	dc.b	IE_SETFONT,0
	dc.b	IE_STRING,45+OX,41+OY,"(press [F1] to select it)",0
	dc.b	IE_STRING,45+OX,68+OY,"(press [F2] to select it)",0
	dc.b	IE_STRING,70+OX,86+OY,"(ENTER:compare  ESC:exit)",0
	dc.b	IE_STRING,55+OX,92+OY,"Ibrahim - p.c.scherrer@wanadoo.fr",0
	dc.b	IE_SETFONT,1
	dc.b	IE_STRING,45+OX,33+OY,"First File :",0
	dc.b	IE_STRING,45+OX,60+OY,"Second File :",0
	dc.b	IE_END

ieResult:
	dc.b	IE_ANIMEDWIN2,50,40+OX,20+OY,199+OX,100+OY,"Result :",0
	dc.b	IE_END


ieError1
	dc.b	IE_ANIMEDWIN2,50,50+OX,40+OY,189+OX,80+OY,"Error",0
	dc.b	IE_STRING,60+OX,55+OY,"You must select",0
	dc.b	IE_STRING,60+OX,63+OY,"two files",0
	dc.b	IE_END

ieError2
	dc.b	IE_ANIMEDWIN2,50,50+OX,40+OY,189+OX,80+OY,"Error",0
	dc.b	IE_STRING,55+OX,57+OY,"Out of memory",0
	dc.b	IE_END

ieError3
	dc.b	IE_ANIMEDWIN2,50,50+OX,40+OY,189+OX,80+OY,"Error",0
	dc.b	IE_STRING,60+OX,55+OY,"Vars have different",0
	dc.b	IE_STRING,60+OX,63+OY,"sizes.",0
	dc.b	IE_END

ieNoDiff
	dc.b	IE_ANIMEDWIN2,50,50+OX,40+OY,189+OX,80+OY,"Result",0
	dc.b	IE_STRING,60+OX,57+OY,"No Difference",0
	dc.b	IE_END

sFormat	dc.b	"Offset %04X%04X : v1=%02X v2=%02X",0
hVar1	dc.w	0
hVar2	dc.w	0

_comment dc.b	"File Compare v1.00",0


;-------------------- End of program ------------------

	end


